//
//  MotionMonitorViewController.m
//  MotionMonitor
//
//  Created by Dave Mark on 12/15/10.
//  Copyright 2010 __MyCompanyName__. All rights reserved.
//

#import "MotionMonitorViewController.h"

@implementation MotionMonitorViewController
@synthesize motionManager;
@synthesize accelerometerLabel;
@synthesize gyroscopeLabel;
@synthesize updateTimer;


// Implementacja metody viewDidLoad pozwala na przeprowadzenie konfiguracji po wczytaniu widoku, zazwyczaj z pliku nib.
- (void)viewDidLoad {
    [super viewDidLoad];
    self.motionManager = [[[CMMotionManager alloc] init] autorelease];
    
    if (motionManager.accelerometerAvailable) {
        motionManager.accelerometerUpdateInterval = 1.0/10.0;
        [motionManager startAccelerometerUpdates];
    } else {
        accelerometerLabel.text = @"To urządzenie nie posiada przyspieszeniomierza.";
    }
    if (motionManager.gyroAvailable) {
        motionManager.gyroUpdateInterval = 1.0/10.0;
        [motionManager startGyroUpdates];
    } else {
        gyroscopeLabel.text = @"To urządzenie nie posiada żyroskopu.";
    }
}

- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
    self.updateTimer = [NSTimer scheduledTimerWithTimeInterval:1.0/10.0
                                                        target:self
                                                      selector:@selector(updateDisplay) 
                                                      userInfo:nil 
                                                       repeats:YES];
}

- (void)viewDidDisappear:(BOOL)animated {
    [super viewDidDisappear:animated];
    self.updateTimer = nil;
}

- (void)updateDisplay {
    if (motionManager.accelerometerAvailable) {
        CMAccelerometerData *accelerometerData = motionManager.accelerometerData;
        accelerometerLabel.text  = [NSString stringWithFormat:
									@"Przyspieszeniomierz\n-----------\nx: %+.2f\ny: %+.2f\nz: %+.2f", 
									accelerometerData.acceleration.x, 
									accelerometerData.acceleration.y, 
									accelerometerData.acceleration.z];
    }
    if (motionManager.gyroAvailable) {
        CMGyroData *gyroData = motionManager.gyroData;
        gyroscopeLabel.text = [NSString stringWithFormat:
							   @"Żyroskop\n--------\nx: %+.2f\ny: %+.2f\nz: %+.2f", 
							   gyroData.rotationRate.x, 
							   gyroData.rotationRate.y, 
							   gyroData.rotationRate.z];
    }
}

- (void)didReceiveMemoryWarning {
	// Jeżeli widok nie posiada widoku nadrzędnego, wówczas zostanie usunięty z pamięci.
    [super didReceiveMemoryWarning];
	
	// Usunięcie z pamięci wszelkich buforowanych danych, obrazów i innych zasobów, które obecnie nie są używane.
}

- (void)viewDidUnload {
    // Usunięcie wszystkich „przytrzymanych” podwidoków widoku głównego,
    // na przykład self.myOutlet = nil;
    self.motionManager = nil;
    self.accelerometerLabel = nil;
    self.gyroscopeLabel = nil;
    [super viewDidUnload];
}

- (void)dealloc {
    [motionManager release];
    [accelerometerLabel release];
    [gyroscopeLabel release];
    [updateTimer release];
    [super dealloc];
}

@end
